* HECKMAN SAMPLE SELECTION MODELS
* Section 6
* MARY-ALICE DOYLE
* LAST EDITED: 02 October 2018

*********
* SETUP
*********
*cd [specify filepath for working directory]
do ".\Stata files\Regression setup.do"
set more off


*************
* HYPOTHESIS 2: BOUNDED RATIONALITY
*************
* compare determinants of net benefit to determinants of perceived monetary benefit
* create variable = 0 if respondent believes they break even or lose out, =1 if they belieev they benefit from their credit card
recode q7b -2 =.
recode q7b -1 = .
gen perceivedbenefit = 0
replace perceivedbenefit = 1 if q8g==1

* For respondents who make a loss:
* create a variable = 1 if respondent is losing but believes they are gaining, 
* =0 if losing and believes they are losing or breaking even
* (missing if net benefit >-50)
gen losing = 0 if netbenefit1111<=-50
replace losing = 1 if netbenefit1111<=-50 & inlist(q8g,1)

* Heckman sample selection probit model
//selection stage includes variables likely to relate to credit card demand:
// age, income, attitudes towards credit cards, 
// wealth, internet access, employment and education
heckprobit losing i.type if idtag==1 [pw=w1], vce(robust) select(i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2)
margins, dydx(_all) post
outreg2 using ".\Excel output\6.2 heckman.xls", replace dec(2)

heckprobit losing i.type  i.hhincq i.deposit i.empstatcons i.educat2 i.agebin if idtag==1 [pw=w1], difficult vce(robust) select(i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2)
margins, dydx(_all) post
outreg2 using ".\Excel output\6.2 heckman.xls",  dec(2)
* ^ I would like to add # CCs into the main stage of this regression as in the original model, but when I do it does not converge. 


* in text: adjusted r-squared of 0.05 in first 'stage'
gen missing = .
replace missing = 1 if losing ==.
replace missing = 0 if losing !=.
reg missing i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2 if idtag==1 [pw=w1], vce(robust)
display e(r2_a)

*****
* BARRIERS TO SWITCHING REGRESSION
*****
 recode q8g -1=2
 label define q8g 0 "Netural (0)" 1 "Better off (1)" 2 "Worse off (2)" 4 "Not sure (4)", replace
 label values q8g q8g
 recode ccmaintype -1=.
* Probit MEs for impact of gain/loss and demographics on probabiliy of considering switching 
heckprobit considered i.gain i.loss i.hhincq  if idtag==1  [pw=w1], vce(robust) select(i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 heckman.xls", replace dec(2)

heckprobit considered i.gain i.loss bankbranches i.hhincq  i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust) select(i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 heckman.xls", append dec(2)

heckprobit considered i.gain i.loss bankbranches i.hhincq##i.q8g i.agebin i.empstatcons i.educat2 i.deposit i.ccnum i.type c.ccmainrate i.ccmaintype if idtag==1  [pw=w1], vce(robust) select(i.hhincq i.agebin i.q2d i.q2c3cc i.q2c2cc i.q2c1cc i.deposits online i.empstatcons i.educat2)
margins, dydx(_all) post
outreg2 using ".\Excel output\7 heckman.xls", append dec(2)
